
/** !------------------------------------------------------------------------->
*
*  @file Config.h
*
*  @creationDate 22 November 2024 11:42:31
*
*  @brief Config File for the C:/Users/Mattia Scalisi/Documents/dSPACE/ConfigurationDesk/6.7/Project_CAN_1/Application_001/Build/Thermal_system_2020/BusRtCode/C1_1/S/Plant/Plant
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2024, dSPACE GmbH. All rights reserved.
*
*!-------------------------------------------------------------------------->*/

/*----------------------------------------------------------------------------*/
/* INCLUDES */
/*----------------------------------------------------------------------------*/
#include "../BusConfiguration.h"
#include "BMUtils.h"

/*----------------------------------------------------------------------------*/
/* DEFINES / ENUMS */
/*----------------------------------------------------------------------------*/
#ifdef ECU_ID
#undef ECU_ID
#endif

#define ECU_ID PLANT

/* User specific return values extending the Std_ReturnType, which is normally used with value E_OK or E_NOT_OK */
#define E_DISABLED    0x02u

/* Common */
#define Queue_Clear ASPECT_UNIQUE(Queue_Clear)

#define Queue_DeInit ASPECT_UNIQUE(Queue_DeInit)

#define Queue_Front ASPECT_UNIQUE(Queue_Front)

#define Queue_GetAvailableSize ASPECT_UNIQUE(Queue_GetAvailableSize)

#define Queue_GetSize ASPECT_UNIQUE(Queue_GetSize)

#define Queue_Init ASPECT_UNIQUE(Queue_Init)

#define Queue_Pop ASPECT_UNIQUE(Queue_Pop)

#define Queue_Pull ASPECT_UNIQUE(Queue_Pull)

#define Queue_Push ASPECT_UNIQUE(Queue_Push)

#define Det_Init ASPECT_UNIQUE(Det_Init)

#define Det_ReportError ASPECT_UNIQUE(Det_ReportError)

#define Det_Start ASPECT_UNIQUE(Det_Start)

#define Det_GetVersionInfo ASPECT_UNIQUE(Det_GetVersionInfo)

#define TimeControl_getTime ASPECT_UNIQUE(TimeControl_getTime)


/* CanIf */
#define CanIf_InitFunction ASPECT_UNIQUE(CanIf_InitFunction)

#define CanIf_InitController ASPECT_UNIQUE(CanIf_InitController)

#define CanIf_SetControllerMode ASPECT_UNIQUE(CanIf_SetControllerMode)

#define CanIf_GetControllerMode ASPECT_UNIQUE(CanIf_GetControllerMode)

#define CanIf_Transmit ASPECT_UNIQUE(CanIf_Transmit)

#define CanIf_ReadRxPduData ASPECT_UNIQUE(CanIf_ReadRxPduData)

#define CanIf_ReadTxNotifStatus ASPECT_UNIQUE(CanIf_ReadTxNotifStatus)

#define CanIf_ReadRxNotifStatus ASPECT_UNIQUE(CanIf_ReadRxNotifStatus)

#define CanIf_SetPduMode ASPECT_UNIQUE(CanIf_SetPduMode)

#define CanIf_GetPduMode ASPECT_UNIQUE(CanIf_GetPduMode)

#define CanIf_GetVersionInfo ASPECT_UNIQUE(CanIf_GetVersionInfo)

#define CanIf_SetDynamicTxId ASPECT_UNIQUE(CanIf_SetDynamicTxId)

#define CanIf_SetTransceiverMode ASPECT_UNIQUE(CanIf_SetTransceiverMode)

#define CanIf_GetTransceiverMode ASPECT_UNIQUE(CanIf_GetTransceiverMode)

#define CanIf_GetTrcvWakeupReason ASPECT_UNIQUE(CanIf_GetTrcvWakeupReason)

#define CanIf_SetTransceiverWakeupMode ASPECT_UNIQUE(CanIf_SetTransceiverWakeupMode)

#define CanIf_CheckWakeup ASPECT_UNIQUE(CanIf_CheckWakeup)

#define CanIf_CheckValidation ASPECT_UNIQUE(CanIf_CheckValidation)

#define CanIf_GetTxConfirmationState ASPECT_UNIQUE(CanIf_GetTxConfirmationState)

#define CanIf_ClearTrcvWufFlag ASPECT_UNIQUE(CanIf_ClearTrcvWufFlag)

#define CanIf_CheckTrcvWakeFlag ASPECT_UNIQUE(CanIf_CheckTrcvWakeFlag)

#define CanIf_TransmitFunction ASPECT_UNIQUE(CanIf_TransmitFunction)

#define CanIf_TransmitFrameFunction ASPECT_UNIQUE(CanIf_TransmitFrameFunction)

#define CanIf_InitDefaultConfig ASPECT_UNIQUE(CanIf_InitDefaultConfig)

#define CanIf_Init ASPECT_UNIQUE(CanIf_Init)

#define CanIf_VariableInitialize ASPECT_UNIQUE(CanIf_VariableInitialize)

#define CanIf_TxConfirmation ASPECT_UNIQUE(CanIf_TxConfirmation)

#define CanIf_RxIndication ASPECT_UNIQUE(CanIf_RxIndication)

#define CanIf_RxInterruptIndication ASPECT_UNIQUE(CanIf_RxInterruptIndication)

#define CanIf_CancelTxConfirmation ASPECT_UNIQUE(CanIf_CancelTxConfirmation)

#define CanIf_ControllerBusOff ASPECT_UNIQUE(CanIf_ControllerBusOff)

#define CanIf_ConfirmPnAvailability ASPECT_UNIQUE(CanIf_ConfirmPnAvailability)

#define CanIf_ClearTrcvWufFlagIndication ASPECT_UNIQUE(CanIf_ClearTrcvWufFlagIndication)

#define CanIf_CheckTrcvWakeFlagIndication ASPECT_UNIQUE(CanIf_CheckTrcvWakeFlagIndication)

#define CanIf_TrcvModeIndication ASPECT_UNIQUE(CanIf_TrcvModeIndication)

#define gp_CanIf_ChannelAddress ASPECT_UNIQUE(gp_CanIf_ChannelAddress)

#define g_CntrlFlags ASPECT_UNIQUE(g_CntrlFlags)

#define CanIf_DevErrorDetect ASPECT_UNIQUE(CanIf_DevErrorDetect)

#define CanIf_MultipleDriverSupport ASPECT_UNIQUE(CanIf_MultipleDriverSupport)

#define CanIf_PublicPNSupport ASPECT_UNIQUE(CanIf_PublicPNSupport)

#define CanIf_ReadRxPduDataApi ASPECT_UNIQUE(CanIf_ReadRxPduDataApi)

#define CanIf_ReadTxPduNotifyStatusApi ASPECT_UNIQUE(CanIf_ReadTxPduNotifyStatusApi)

#define CanIf_ReadRxPduNotifyStatusApi ASPECT_UNIQUE(CanIf_ReadRxPduNotifyStatusApi)

#define CanIf_SetDynamicTxIdApi ASPECT_UNIQUE(CanIf_SetDynamicTxIdApi)

#define CanIf_DlcCheck ASPECT_UNIQUE(CanIf_DlcCheck)

#define CanIf_WakeupSupport ASPECT_UNIQUE(CanIf_WakeupSupport)

#define CanIf_SoftwareFilterType ASPECT_UNIQUE(CanIf_SoftwareFilterType)

#define CanIf_PublicWakeupCheckValidationSupport ASPECT_UNIQUE(CanIf_PublicWakeupCheckValidationSupport)

#define CanIf_TransmitCancellation ASPECT_UNIQUE(CanIf_TransmitCancellation)

#define CanIf_PublicTxConfirmPollingSupport ASPECT_UNIQUE(CanIf_PublicTxConfirmPollingSupport)

#define CanIf_VersionInfoApi ASPECT_UNIQUE(CanIf_VersionInfoApi)

#define CanIf_MaxNumberOfHrh ASPECT_UNIQUE(CanIf_MaxNumberOfHrh)

#define CanIf_NumberOfCanHWUnits ASPECT_UNIQUE(CanIf_NumberOfCanHWUnits)


/* Rte */
#define Rte_ReadSignal ASPECT_UNIQUE(Rte_ReadSignal)

#define Rte_WriteSignal ASPECT_UNIQUE(Rte_WriteSignal)

#define Rte_SetCodedValue ASPECT_UNIQUE(Rte_SetCodedValue)

#define Rte_SetPhysicalValue ASPECT_UNIQUE(Rte_SetPhysicalValue)

#define Rte_VariableInitialize ASPECT_UNIQUE(Rte_VariableInitialize)


/* Com */
#define Com_Init ASPECT_UNIQUE(Com_Init)

#define Com_DeInit ASPECT_UNIQUE(Com_DeInit)

#define Com_VariableInitialize ASPECT_UNIQUE(Com_VariableInitialize)

#define Com_OnStart ASPECT_UNIQUE(Com_OnStart)

#define Com_TriggerTransmit ASPECT_UNIQUE(Com_TriggerTransmit)

#define Com_SendSignal ASPECT_UNIQUE(Com_SendSignal)

#define Com_SendSignalGroup ASPECT_UNIQUE(Com_SendSignalGroup)

#define Com_UpdateShadowSignal ASPECT_UNIQUE(Com_UpdateShadowSignal)

#define Com_InvalidateSignal ASPECT_UNIQUE(Com_InvalidateSignal)

#define Com_InvalidateShadowSignal ASPECT_UNIQUE(Com_InvalidateShadowSignal)

#define Com_InvalidateSignalGroup ASPECT_UNIQUE(Com_InvalidateSignalGroup)

#define Com_TxConfirmation ASPECT_UNIQUE(Com_TxConfirmation)

#define Com_ReceiveSignal ASPECT_UNIQUE(Com_ReceiveSignal)

#define Com_ReceiveSignalGroup ASPECT_UNIQUE(Com_ReceiveSignalGroup)

#define Com_ReceiveShadowSignal ASPECT_UNIQUE(Com_ReceiveShadowSignal)

#define Com_RxIndication ASPECT_UNIQUE(Com_RxIndication)

#define Com_TriggerIPDUSend ASPECT_UNIQUE(Com_TriggerIPDUSend)

#define Com_TriggerIPDU ASPECT_UNIQUE(Com_TriggerIPDU)

#define Com_GetVersionInfo ASPECT_UNIQUE(Com_GetVersionInfo)

#define Com_GetStatus ASPECT_UNIQUE(Com_GetStatus)

#define Com_MainFunctionTx ASPECT_UNIQUE(Com_MainFunctionTx)

#define Com_MainFunctionRx ASPECT_UNIQUE(Com_MainFunctionRx)

#define Com_MainFunction ASPECT_UNIQUE(Com_MainFunction)

#define Com_TaskMain ASPECT_UNIQUE(Com_TaskMain)

#define Com_StartOfReception ASPECT_UNIQUE(Com_StartOfReception)

#define Com_TpRxIndication ASPECT_UNIQUE(Com_TpRxIndication)

#define Com_TpTxConfirmation ASPECT_UNIQUE(Com_TpTxConfirmation)

#define Com_CopyRxData ASPECT_UNIQUE(Com_CopyRxData)

#define Com_CopyTxData ASPECT_UNIQUE(Com_CopyTxData)

#define Com_PduEnabledSendCheck ASPECT_UNIQUE(Com_PduEnabledSendCheck)


/* PduR */
#define PduR_GetVersionInfo ASPECT_UNIQUE(PduR_GetVersionInfo)

#define PduR_Init ASPECT_UNIQUE(PduR_Init)

#define PduR_VariableInitialize ASPECT_UNIQUE(PduR_VariableInitialize)

#define PduR_ComTransmit ASPECT_UNIQUE(PduR_ComTransmit)

#define PduR_MultiIfTransmit ASPECT_UNIQUE(PduR_MultiIfTransmit)

#define PduR_IpduMTransmit ASPECT_UNIQUE(PduR_IpduMTransmit)

#define PduR_IpduMTriggerTransmit ASPECT_UNIQUE(PduR_IpduMTriggerTransmit)

#define PduR_IpduMTxConfirmation ASPECT_UNIQUE(PduR_IpduMTxConfirmation)

#define PduR_IpduMRxIndication ASPECT_UNIQUE(PduR_IpduMRxIndication)

#define PduR_CanIfTxConfirmation ASPECT_UNIQUE(PduR_CanIfTxConfirmation)

#define PduR_CanIfRxIndication ASPECT_UNIQUE(PduR_CanIfRxIndication)

#define PduR_CanNmTxConfirmation ASPECT_UNIQUE(PduR_CanNmTxConfirmation)

#define PduR_CanNmTriggerTransmit ASPECT_UNIQUE(PduR_CanNmTriggerTransmit)

#define PduR_CanNmRxIndication ASPECT_UNIQUE(PduR_CanNmRxIndication)

#define PduR_LinIfTxConfirmation ASPECT_UNIQUE(PduR_LinIfTxConfirmation)

#define PduR_LinIfRxIndication ASPECT_UNIQUE(PduR_LinIfRxIndication)

#define PduR_LinIfTriggerTransmit ASPECT_UNIQUE(PduR_LinIfTriggerTransmit)

#define PduR_SecOCTransmit ASPECT_UNIQUE(PduR_SecOCTransmit)

#define PduR_SecOCTriggerTransmit ASPECT_UNIQUE(PduR_SecOCTriggerTransmit)

#define PduR_SecOCTxConfirmation ASPECT_UNIQUE(PduR_SecOCTxConfirmation)

#define PduR_SecOCRxIndication ASPECT_UNIQUE(PduR_SecOCRxIndication)

#define PduR_SoAdRxIndication ASPECT_UNIQUE(PduR_SoAdRxIndication)

#define PduR_SoAdTxConfirmation ASPECT_UNIQUE(PduR_SoAdTxConfirmation)

#define PduR_SoAdTpCopyRxData ASPECT_UNIQUE(PduR_SoAdTpCopyRxData)

#define PduR_SoAdTpCopyTxData ASPECT_UNIQUE(PduR_SoAdTpCopyTxData)

#define PduR_SoAdTpRxIndication ASPECT_UNIQUE(PduR_SoAdTpRxIndication)

#define PduR_SoAdTpStartOfReception ASPECT_UNIQUE(PduR_SoAdTpStartOfReception)

#define PduR_SoAdTpTxConfirmation ASPECT_UNIQUE(PduR_SoAdTpTxConfirmation)

#define PduR_SoAdIfTriggerTransmit ASPECT_UNIQUE(PduR_SoAdIfTriggerTransmit)

#define PduR_SoAdIfTxConfirmation ASPECT_UNIQUE(PduR_SoAdIfTxConfirmation)

#define PduR_SoAdIfRxIndication ASPECT_UNIQUE(PduR_SoAdIfRxIndication)

#define PduR_SoConModeChg ASPECT_UNIQUE(PduR_SoConModeChg)

#define PduR_LocalIpAddrAssignmentChg ASPECT_UNIQUE(PduR_LocalIpAddrAssignmentChg)

#define PduR_J1939TpCopyRxData ASPECT_UNIQUE(PduR_J1939TpCopyRxData)

#define PduR_J1939TpCopyTxData ASPECT_UNIQUE(PduR_J1939TpCopyTxData)

#define PduR_J1939TpRxIndication ASPECT_UNIQUE(PduR_J1939TpRxIndication)

#define PduR_J1939TpStartOfReception ASPECT_UNIQUE(PduR_J1939TpStartOfReception)

#define PduR_J1939TpTxConfirmation ASPECT_UNIQUE(PduR_J1939TpTxConfirmation)

#define PduR_J1939TpTriggerTransmit ASPECT_UNIQUE(PduR_J1939TpTriggerTransmit)

#define PduR_Config ASPECT_UNIQUE(PduR_Config)


/* SchM */
#define SchM_Init ASPECT_UNIQUE(SchM_Init)

#define SchM_DeInit ASPECT_UNIQUE(SchM_DeInit)

#define SchM_GetVersionInfo ASPECT_UNIQUE(SchM_GetVersionInfo)

#define SchM_Enter_CanIf ASPECT_UNIQUE(SchM_Enter_CanIf)

#define SchM_Exit_CanIf ASPECT_UNIQUE(SchM_Exit_CanIf)

#define SchM_Enter_LinIf ASPECT_UNIQUE(SchM_Enter_LinIf)

#define SchM_Exit_LinIf ASPECT_UNIQUE(SchM_Exit_LinIf)

#define SchM_Enter_IpduM ASPECT_UNIQUE(SchM_Enter_IpduM)

#define SchM_Exit_IpduM ASPECT_UNIQUE(SchM_Exit_IpduM)

#define SchM_Enter_SecOC ASPECT_UNIQUE(SchM_Enter_SecOC)

#define SchM_Exit_SecOC ASPECT_UNIQUE(SchM_Exit_SecOC)



#ifdef __cplusplus
extern "C"
{
#endif

/*----------------------------------------------------------------------------*/
/* FORWARD DECLARATIONS OF STATIC FUNCTIONS */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* GLOBAL VARIABLES */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* GLOBAL FUNCTIONS */
/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
}
#endif


